import { useParams } from "react-router";
import AppLayout from "../../../components/AppLayout";
import MessageDetails from "../../../components/Email/MessageDetails";
import axios from "axios";
import { formatDate, formatTime, getToken } from "../../../utils/front";
import { useEffect, useState } from "react";
import Loading from "../../../components/Loading";
import MailToolbar from "../../../components/Email/MailToolbar";
import {addEmptyLines, getEmails, isMailAllowed} from "../../../components/Email/utils/methods";
import styles from "../../../components/Email/mails.module.css"
import PreventBack from "../../../components/PreventBack";
import ComposeForm from "../../../components/Email/ComposeForm";

export default function Page(){
    const {id} = useParams<{ id: string }>();
    const {folder} = useParams<{ folder: string }>();
    const [folders, setFolders] = useState<[]>([]);
    const userToken = getToken();    

    const [loading, setLoading] = useState(false);
    interface MessageDetails {
        id?: string;
        from?: string;
        to?: string[];
        cc?: string[];
        bcc?: string[];
        subject?: string;
        date?: string;
        text?: string;
        html?: string;
        headers?: string;
        row?: string;
        methods?: any;
        attachments?: { name: string; size: string; content: string; extension: string }[];
        folder?: string;
    }

    const [msgDetails, setMsgDetails] = useState<MessageDetails>({});
    const [showDetails, setShowDetails] = useState(false);
    const [showHeaders, setShowHeaders] = useState(false);
    const [showSource, setShowSource] = useState(false);
    const [showPlain, setShowPlain] = useState(false);
    const [allowAssets, setAllowAssets] = useState("no");
    const [mode, setMode] = useState("compose");
    const [direction, setDirection] = useState("left");
    const [isOpened, setIsOpened] = useState(false);

    useEffect(() => {
        axios
        .get(import.meta.env.VITE_BASE_URL + "mails", {
            headers: {
                Authorization: "Bearer " + userToken,
            },
        })
        .then((res:any) => {
            if(res.data.status === 'success'){
                setFolders(res.data.folders);
            }
        })
        .catch((err:any) => {
            console.log(err);
        });
    }, []);

    const updateFoldersCountState = () => {
        // Add logic for updating folders count state here
        console.log("updateFoldersCountState called");
    };

    const updateMessagesState = () => {
        // Add logic for updating messages state here
        console.log("updateMessagesState called");
    };

    const spliceMessage = () => {
        // Add logic for splicing a message here
        console.log("spliceMessage called");
    };

    const folderClick = () => {
        // Add logic for folder click here
        console.log("folderClick called");
    };

    const updateHint = () => {
        // Add logic for updating hint here
        console.log("updateHint called");
    };

    function updateDirAndMode(dir:any, modeType:any){
        if(dir){
            setDirection(dir);
        }
        if(modeType){
            setMode(modeType);
        }
        setIsOpened(true);
    }

    const getMessage = () => {
        setLoading(true);
        axios
        .get(import.meta.env.VITE_BASE_URL + "mail/message/" + folder + "/" + id, {
            headers: {
                Authorization: "Bearer " + userToken,
            },
        })
        .then((res)=>{
            const data = res.data;
            setMsgDetails(data);
            setLoading(false);
        })
        .catch((err:any) => {
            console.log(err);
        })
        .finally(() => {
            setLoading(false);
        })
    };

    useEffect(()=>{
        getMessage();
    },[folder, id]);

    function Emails({emails}: { emails: [] | null }) {
        return (
            <span>
              {emails &&
                  emails.map((person: any, index: number) => (
                      <a key={"person-" + index}
                         href={`mailto::${person.mail}`}>{person.personal ? person.personal : person.mail}</a>
                  ))}
            </span>
        )
    }

    useEffect(() => {

        const allowedMails = localStorage.getItem('allowedMails');
        if (msgDetails.from) {
            let mails = getEmails(msgDetails.from);
            if (allowedMails) {
                let allowedMailsArr = JSON.parse(allowedMails);
                mails.map(((mail: string) => {
                    if (!allowedMailsArr.includes(mail)) {
                        allowedMailsArr.push(mail);
                    }
                }));
                localStorage.setItem('allowedMails', JSON.stringify(allowedMailsArr));
            } else {
                localStorage.setItem('allowedMails', JSON.stringify(mails));
            }
        }

    }, [allowAssets, loading]);
    
    return(
        <PreventBack title={folder?.toLowerCase()}>
            { loading ? <Loading/>
            :
            <div className={styles.msgDetailsWrap}>
                {msgDetails && msgDetails.id ? (
                    <>
                        <div className={styles.msgContentTitle}>
                            <div>
                                <p className={styles.msgMetaHead}>
                                    {msgDetails.subject}
                                </p>
                                <span className={styles.msgDate}>
                                    {formatDate(msgDetails.date)}{" "}
                                    {formatTime(msgDetails.date)}
                                </span>
                                <div className={`${styles.msgMeta}${ showDetails ? " " + styles.itemsStart : "" }`}>
                                    <div className={styles.detailsDiv}>
                                        <span className={styles.msgMetaList}>
                                            <span>
                                                <b>From</b>
                                                <img width={40} height={40} alt="" src="/contactpic.svg" />
                                                <Emails emails={msgDetails.from}/>
                                            </span>

                                            {showDetails && (
                                            <span className={styles.msgMetaTo}>
                                                <b>To</b>
                                                <Emails emails={msgDetails.to}/>
                                            </span>
                                            )}
                                            {showDetails && msgDetails.cc && (
                                                <span className={styles.msgMetaCC}>
                                                <b>CC</b>
                                                <Emails emails={msgDetails.cc}/>
                                                </span>
                                            )}

                                            {showDetails && msgDetails.bcc && (
                                                <span className={styles.msgMetaCC}>
                                                <b>BCC</b>
                                                <Emails emails={msgDetails.bcc}/>
                                                </span>
                                            )}
                                        </span>

                                        <span className={styles.msgHeaderLinks}>
                                            <span onClick={() => setShowDetails((prev) => !prev)}>Details</span>
                                            {/* <span onClick={() => setShowHeaders(true)}>
                                                <i className="ri-information-line"></i>Headers
                                            </span>
                                            <span onClick={() => setShowPlain((prev) => !prev)}>
                                                <i className="ri-menu-line"></i>
                                                <span>Plain text</span>
                                            </span> */}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {showHeaders && (
                            <div className={styles.showHeaders}>
                                <i className="ri-close-line" onClick={() => setShowHeaders(false)}></i>
                                <div>{msgDetails.headers && msgDetails.headers}</div>
                            </div>
                        )}

                        {showSource && (
                            <div className={styles.showHeaders}>
                                <i className="ri-close-line" onClick={() => setShowSource(false)}></i>
                                <div className={styles.showSource}>
                                    <pre>{msgDetails.row && msgDetails.row}</pre>
                                </div>
                            </div>
                        )}

                        {showPlain ? (
                            msgDetails.text && ( <pre className={styles.plainText}>{msgDetails.text}</pre> )
                        ) : (<>
                            {!isMailAllowed(msgDetails) && folder != 'Drafts' && (
                                <div className={styles.warning}>
                                    <i className="ri-error-warning-fill"></i>
                                    To protect your privacy remote resources have been blocked.
                                    <button className="btn btn-sm no-wrap" onClick={() => msgDetails.id && setAllowAssets(msgDetails.id) }>Allow</button>
                                </div>
                            )}
                            {folder == 'Drafts' && msgDetails &&
                                <div className={styles.information}>
                                    <i className="ri-error-warning-fill"></i>
                                    This is a draft message.
                                    {/* <button className="btn btn-sm" onClick={() => { methods.updateDirAndMode('right', 'draft'); }}>
                                        Edit
                                    </button> */}
                                </div>
                            }
                            {msgDetails.html && (
                                <div className={styles.frameWrap}>
                                    <iframe id="msgFrame" srcDoc={msgDetails.html}></iframe>
                                </div>
                            )}
                            {!msgDetails.html &&
                                <pre>
                                    {addEmptyLines(msgDetails.text)}
                                </pre>
                            }
                            {(msgDetails.attachments ?? []).length > 0 && (
                                <ul className={styles.attachList}>
                                    {(msgDetails.attachments ?? []).map((attachment: any, index) => (
                                        <li key={index}>
                                            <a href={`data:application/octet-stream;base64,${attachment.content}`} download={attachment.name} title={attachment.name}>
                                                <span className={styles.attchExt}>
                                                    <span>{attachment.extension}</span>
                                                    <img alt="" src="/ext.svg" width={36} height={46} />
                                                </span>
                                                <span className={styles.attachName}>
                                                    <b>{attachment.name}</b>
                                                    <i>({attachment.size})</i>
                                                </span>
                                            </a>
                                        </li>
                                    ))}
                                </ul>
                            )}
                        </>)}
                    </>
                ) : (
                    <div className="ryb-msgs-intro">
                        <img width={400} height={328} alt="" src="/no-mails.png"/>
                        <div className="ryb-msgs-head">
                            There are no messages selected!
                        </div>
                        Select one and start Emailing!
                    </div>
                )}
                <MailToolbar
                    msgID={msgDetails?.id}
                    msgDetails={msgDetails}
                    folders={folders}
                    folderId={folder}
                    methods={{
                        updateMessagesState,
                        updateFoldersCountState,
                        spliceMessage,
                        updateHint,
                        folderClick,
                        updateDirAndMode
                    }}
                    setMsgDetails={setMsgDetails}
                    setShowSource={setShowSource}
                />
            </div>
            }
            {isOpened && (
                <ComposeForm
                    direction={direction}
                    msgDetails={msgDetails}
                    mode={mode}
                    setIsOpened={setIsOpened}
                    folderClick={folderClick}
                />
            )}
        </PreventBack>
    );
}